//#define DEBUG



#include "DHT.h"
#include "Barometer.h"
#include <Wire.h>

Barometer bmp180;

//GPIO2 is blue led
DHT dht(13,DHT22,11); //default:11

#define PIRPIN 12

//timings
long lastsensorreadtime=0;
long sensorupdatedelay=60000; //delay for reading and transmitting
long lastPIRtime=0;
long PIRdelay=2000;
  int PIR_checkcounter=0;
  int movementPIR_counter=0;

long lastLDRtime=0;
long LDRdelay=5000;
  int LDR_readcounter=0;
  double LDRLightcommulative=0;


struct Values {
  uint8_t id;
  float humidityDHT; //[%RH]
  float temperatureDHT; //[deg C]
  float temperatureBMP; ///[deg C]
  float pressureBMP; // [hPa]
  float lightLDR; //[Lux]
  int movementPIR; //[seconds with movement]
  long rssi; //wifi rssi
};
Values values;

uint16_t readingcounter=0;

//Wifi
#include <ESP8266WiFi.h>
//#include <ESP8266WiFiMulti.h>

//ESP8266WiFiMulti WiFiMulti;


const uint16_t port = 5005;
//const char * host = "192.168.178.19"; // ip or dns
const char * host = "192.168.178.5"; //homeserver
//const char * host = "195.160.169.42";

const char* SSID="Fischnet";
const char* password="bierkiste";

/*const char* SSID="CTDO-g";
const char* password="ctdo2342";*/

char tempstring[16]; //for dtostrf



// Light calibration data
// out[] holds the values wanted in lux/10

//default
//#define LDRARRAYSIZE 9
//static const unsigned int out_ldr[] = { 7, 30, 45, 65, 150, 300, 450, 2100, 13000};  // x10  //ULTIMO VALOR REFERENCIA
//static const unsigned int in_ldr[]  = { 100, 350, 430, 500, 680, 780, 950, 1005, 1024 };  // 0 - 1024

//measured 20160709
#define LDRARRAYSIZE 18
static const unsigned int out_ldr[] = {0, 30, 50,  60,  130, 170, 250, 420, 780, 1300,2600, 5000, 5350, 7700, 10900, 12000, 17000,20000};  // x10  (i.e. gets later divided by 10)
static const unsigned int in_ldr[]  = {0, 12, 100, 150, 350, 400, 450, 650, 730,  780, 840, 930,  948 , 970,  993,   1005,  1019, 1023};  // 0 - 1023



double Light(int RawADC0);
void transmit(Values v);
double getAverageLight();
int get_lux(const unsigned int* _in, const unsigned int* _out, byte size);

void setup() {
  Serial.begin(115200);
  Serial.println();
  Serial.println("Welcome");

  pinMode(PIRPIN, INPUT); //pir movement sensor
  Serial.println("initializing ldr pinmode");
  pinMode(A0, INPUT); //ldr
  
  values.id=1;
  Serial.println("initializing dht");
  dht.begin(); // data pin 2
  //Wire.begin(12,14); //i2c for bmp180
  Serial.println("initializing bmp180");
  bmp180.init();
  /*if (!bmp180.begin()){
    Serial.println("#ERROR: BMP180 init fail\n\n");
  }*/

  

  Serial.println("connecting..");
  WiFi.begin(SSID, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());

  
  

}

void loop() {

  if (millis() >= (lastPIRtime+PIRdelay)){
     PIR_checkcounter++;
     if (digitalRead(PIRPIN)){
       movementPIR_counter++;
     }
     lastPIRtime=millis();
  }

  if (millis() >= (lastLDRtime+LDRdelay)){
     
     LDR_readcounter++;
     //LDRLightcommulative+=Light(analogRead(A0)); //read light value from adc
     float ldr_read = get_lux(in_ldr, out_ldr, LDRARRAYSIZE)/10.0;
     LDRLightcommulative+=ldr_read;
     lastLDRtime=millis();

     #ifdef DEBUG   //DEBUG++++++++++++++++
     Serial.print(" -LDRReadcounter:");
     Serial.println(LDR_readcounter);
     Serial.print(" -LDRLightcommulative:");
     Serial.println(LDRLightcommulative);
     Serial.print(" -Light:");
     //Serial.println(Light(analogRead(A0)));
     Serial.println(ldr_read);
     #endif
     
  }

  if (millis() >= (lastsensorreadtime+sensorupdatedelay))
  {

    if (WiFi.status() != WL_CONNECTED) //restart if wifi signal loss
    {
      ESP.reset();
    }

    uint8_t dhtfailcounter=0;
    do{
      values.temperatureDHT = dht.readTemperature();
      if (isnan(values.temperatureDHT) ==1)
        values.temperatureDHT=-80;
      values.humidityDHT = dht.readHumidity();
      if (isnan(values.humidityDHT) ==1 )
        values.humidityDHT=-80;

      if (values.temperatureDHT==-80){
        #ifdef DEBUG   //DEBUG++++++++++++++++
        Serial.print("Fail");
        Serial.println(dhtfailcounter);
        #endif
        delay(1500);  
      }
      
      dhtfailcounter++;
    }while(values.temperatureDHT==-80 && dhtfailcounter<10);
    
  
    values.temperatureBMP=bmp180.bmp085GetTemperature(bmp180.bmp085ReadUT());
    values.pressureBMP=bmp180.bmp085GetPressure(bmp180.bmp085ReadUP())/100.0; //Pa in hPa

    values.lightLDR=getAverageLight();


    values.rssi = WiFi.RSSI(); //get rssi

    #ifdef DEBUG   //DEBUG++++++++++++++++
    Serial.print("RSSI=");
    Serial.println(values.rssi);

    Serial.print("HumDht=");
    Serial.println(values.humidityDHT);
    Serial.print("TempDht=");
    Serial.println(values.temperatureDHT);
  
    Serial.print("PresBMP=");
    Serial.println(values.pressureBMP);
    Serial.print("TempBMP=");
    Serial.println(values.temperatureBMP);
    #endif
  
    //values.movementPIR=movementPIR_counter*(100000/senddelay); //normalize to 1 minute, counter 60=100%
    if (PIR_checkcounter>0){ //no division by 0
      values.movementPIR=movementPIR_counter*100/PIR_checkcounter; //calculates ontime in percent
    }else{
      values.movementPIR=0;
    }
    movementPIR_counter=0; //reset counter
    PIR_checkcounter=0;

    #ifdef DEBUG   //DEBUG++++++++++++++++
    Serial.print("PIR=");
    Serial.println(values.movementPIR);

    Serial.print("lightLDR=");
    Serial.println(values.lightLDR);
    
    Serial.print("Counter="); Serial.println(readingcounter);
    #endif

    transmit(values);

    
    

    lastsensorreadtime=millis();
  }

  

}


/*double Light(int RawADC0){ //quelle: https://arduinodiy.wordpress.com/2013/11/03/measuring-light-with-an-arduino/
  double Vout=RawADC0*0.0048828125; //RawADC0*   (Voltage/1024)
  //int lux=500/(10*((5-Vout)/Vout));//use this equation if the LDR is in the upper part of the divider
  double lux=(2500/Vout-500)/10;
  return lux;
}*/

/*double Light(int RawADC0){ //quelle: http://emant.com/316002.page
  //this values for 3v3 supply and 10k pullup
  double Vout=RawADC0*0.003222656; //RawADC0*   (Voltage/1024)
  //int lux=500/(10*((5-Vout)/Vout));//use this equation if the LDR is in the upper part of the divider
  float lux=(1650.0/Vout-500)/10;
  //lux=((Vmax*500)/Vo - 500  ) /  Pullupresistor(in kOhm)
  return lux;
}*/

//////////////////////////////////////////////////////////////////////////////
// Calculate lux based on rawADC reading from LDR returns value in lux/10
//////////////////////////////////////////////////////////////////////////////
//quelle: https://groups.google.com/forum/#!topic/souliss/1kMAltPB2ME[1-25]
int get_lux(const unsigned int* _in, const unsigned int* _out, byte size)
{
 
        // take care the value is within range
 // val = constrain(val, _in[0], _in[size-1]);


 int val = analogRead(A0);
 #ifdef DEBUG   //DEBUG++++++++++++++++
        Serial.print("LDR RAW=: ");
        Serial.println(val);
 #endif
 
 if (val <= _in[0]) return _out[0];
 if (val >= _in[size-1]) return _out[size-1];


 // search right interval
 byte pos = 1;  // _in[0] allready tested
 while(val > _in[pos]) pos++;


 // this will handle all exact "points" in the _in array
 if (val == _in[pos]) return _out[pos];



 // interpolate in the right segment for the rest
 return map(val, _in[pos-1], _in[pos], _out[pos-1], _out[pos]);
}


void transmit(Values v){
  WiFiClient client;
  if (!client.connect(host, port)) {
      Serial.println("failed");
      return;
  }
  dtostrf(v.id,1,0,tempstring);
  String _id=tempstring;

  dtostrf(v.rssi,1,0,tempstring);
  client.print(",rssi"+_id+"="+tempstring);
  
  dtostrf(v.temperatureDHT,1,1,tempstring);
  client.print(",tdht"+_id+"="+tempstring);
  dtostrf(v.humidityDHT,1,1,tempstring);
  client.print(",hum"+_id+"="+tempstring);

  dtostrf(v.temperatureBMP,1,1,tempstring);
  client.print(",tbmp"+_id+"="+tempstring);
  dtostrf(v.pressureBMP,1,2,tempstring);
  client.print(",prs"+_id+"="+tempstring);

  dtostrf(v.lightLDR,1,1,tempstring);
  client.print(",ldr"+_id+"="+tempstring);

  dtostrf(v.movementPIR,1,0,tempstring);
  client.print(",pir"+_id+"="+tempstring);
  
  client.stop();

  readingcounter++;
}


double getAverageLight(){ //average all readings and reset
  double ldravg=LDRLightcommulative/LDR_readcounter;
  LDR_readcounter=0; LDRLightcommulative=0;
  return ldravg;
}

