/**************************************************************************************/
/***************             Global RX related variables           ********************/
/**************************************************************************************/

#if defined(SPEKTRUM)
  #include <wiring.c>  //Auto-included by the Arduino core... but we need it sooner. 
#endif

//RAW RC values will be store here
#if defined(SERIAL_SUM_PPM)
  volatile uint16_t rcValue[RC_CHANS] = {MIDRC, MIDRC, MIDRC, MIDRC, MIDRC, MIDRC, MIDRC, MIDRC}; // interval [1000;2000]
  static uint8_t rcChannel[RC_CHANS] = {SERIAL_SUM_PPM};
#endif

/**************************************************************************************/
/***************                   RX Pin Setup                    ********************/
/**************************************************************************************/
void configureReceiver() 
{
  int chan;
  /******************    Configure each rc pin for PCINT    ***************************/
  // Init PPM SUM RX
  #if defined(SERIAL_SUM_PPM)
    PPM_PIN_INTERRUPT; 
    for (chan = 0; chan < RC_CHANS; chan++) rcData[chan] = rcValue[rcChannel[chan]];
  #endif
}

/**************************************************************************************/
/***************                PPM SUM RX Pin reading             ********************/
/**************************************************************************************/

volatile bool DataReady;

// Read PPM SUM RX Data
#if defined(SERIAL_SUM_PPM)
void rxInt() 
{
  uint16_t now,diff;
  static uint16_t last = 0;
  static uint8_t chan = 0;
  
  now = micros();
  diff = now - last;
  last = now;
  if(diff>3000) chan = 0;
  else if (DataReady) chan = 20;
  else
  {
    if(1000<diff && diff<1900 && chan<RC_CHANS ) rcValue[chan] = diff;
    chan++;
    if (chan == PPM_NUM_CHAN) DataReady = true;
  }
}
#endif


/**************************************************************************************/
/***************          compute and Filter the RX data           ********************/
/**************************************************************************************/

bool computeRC() 
{
  uint8_t chan;
  if (DataReady)
  {
    DataReady = false;
    for (chan = 0; chan < RC_CHANS; chan++) rcData[chan] = rcValue[rcChannel[chan]];
    return true;
  }
  return false;
}





